%% Code to generate transmit beampatterns for the proposed codebook


clear all
close all
clc


N_t = 32;
d_t = 0.5; % regular array at the transmitter

s_set = 1:2; % set of stages to be plotted

for loop_outer=1:length(s_set)

M = 128; % grid points
K = 2; %  Beams per stage
s = s_set(loop_outer); % Stage index
ncodes = K^s;

W = get_code_TX(N_t, d_t, M, K, s);
phi_d2 = 0:1:360;
cost_2 = zeros(K,length(phi_d2));

for k =1:ncodes
    a_ref = W(:,k);
    for i=1:length(phi_d2)
            a = gen_a(N_t, d_t,(phi_d2(i)));
        cost_2(k,i) = abs(a'*a_ref);
    end
end

subplot(1,2,loop_outer)
for k=1:ncodes
     polarplot(phi_d2*pi/180,cost_2(k,:),'LineWidth',1.2);
    hold on;
end
grid on
title(['Stage ',num2str(s)]);
set(gca,'FontSize',10)


end


